//Verification of sampling Theorem
//This program verifies Sampling Theorem for sin(20.pi.t) under instantaneous sampling
//Windows 10
//Scilab 6.1.0
clear
clc
t1=input('Enter the lower limit of time axis:')
t2=input('Enter the upper limit of time axis:')
s=input('Enter the spacing between the adjacent value of time axis:')
f=input('Enter the baseband signal frequency:')
t=t1:s:t2;
x=sin(2*%pi*f*t);
s1=zeros(1,length(t));
n=input('Enter the integer which decides the sampling frequency:')
//Generation of sampling signal
for i=1:length(t)
    if n*i<=length(t)
        s1(n*i)=1;
    end
end
//Generation of Sampled Signal
s11=s1.*x;
//Reconstruction Filter
RC=1/(2*%pi*f);
h=(1/RC)*exp(-t/RC);
//Signal reconstruction
y=conv(h,conv(h,s11));
subplot(4,1,1)
plot(t,x,'linewidth',2)
xgrid
xtitle("Baseband signal of frquency 10Hz","Time","Amplitude")
legend("Signal to be sampled",3)
subplot(4,1,2)
xset("thickness",2)
plot2d3(t,s1,style=-2)
xtitle("Sampling Signal")
subplot(4,1,3)
xset("thickness",2)
plot2d3(t,s11,style=-2)
xtitle("Sampled Signal")
subplot(4,1,4)
plot(t,y(1:length(t))/length(y),'linewidth',2)
xtitle("Signal at the output of the reconstruction Filter","Time","Amplitude")
legend("Recovered Signal",3)


//output Test case 
//lower limit of time axis: 0
//upper limit of time axis: 0.2
//spacing between the adjacent value of time axis: 0.001
//baseband signal frequency: 10
//integer which decides the sampling frequency: 10

//output Test case 
//lower limit of time axis: 0
//upper limit of time axis: 0.2
//spacing between the adjacent value of time axis: 0.001
//baseband signal frequency: 10
//integer which decides the sampling frequency: 5



